package w83b.w83bOperacionesPaso.w83bListados.w83bImpugnaciones;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaResueltasExcelAction.
 */
public class W83bTablaResueltasExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListResueltasImpug.xls";
		InputStream inputStream = W83bTablaResueltasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaImpugnaciones = (ArrayList)contexto.get("W83bListImpugnacionesBean");
        W83bListImpugnacionesBean listadoResBean = (W83bListImpugnacionesBean)contexto.get("W83bListadosImpugBean");                       
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                       

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                       
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                       
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                       
        
        HashMap mapaResueltas=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                       
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                       
        HSSFCell cell = row.createCell((short)3);                       
        row = sheet.getRow((short)4);                       
        cell = row.getCell((short)5);                       
                
        StringBuffer tituloImagenEs = (StringBuffer)mapaResueltas.get("tituloDepEs");                       
        StringBuffer tituloImagenEu =  (StringBuffer)mapaResueltas.get("tituloDepEu");                       
        cell.setCellValue(tituloImagenEu.toString());                       
        
        cell = row.getCell((short)8);                       
        cell.setCellValue(tituloImagenEs.toString());                       
        
        tituloImagenEs = (StringBuffer)mapaResueltas.get("tituloDelelegacionEs");                       
        tituloImagenEu = (StringBuffer)mapaResueltas.get("tituloDelelegacionEu");                       
        
        row = sheet.getRow((short)6);                       
        cell = row.getCell((short)5);                       
        cell.setCellValue(tituloImagenEu.toString());                       
        
        cell = row.getCell((short)8);                       
        cell.setCellValue(tituloImagenEs.toString());                       
        
        row = sheet.getRow((short)9);                       
        cell = row.getCell((short)0);                       
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.listados.impugRes",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.listados.impugRes",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());                       
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.nimpudesde"));
        cell = row.createCell((short)2); 
        StringBuffer numImDesde = new StringBuffer(listadoResBean.getTerritorio());
        if(StringUtils.isNotEmpty(listadoResBean.getAgnoImpugnacionDesde())){
        	if(StringUtils.isNotEmpty(listadoResBean.getTerritorio())){
        		numImDesde.append("/");
        	}
        	numImDesde.append(listadoResBean.getAgnoImpugnacionDesde());
        	if(StringUtils.isNotEmpty(listadoResBean.getNumImpugnacionDesde())){
        		numImDesde.append("/").append(listadoResBean.getNumImpugnacionDesde());
        	}
        }
        cell.setCellValue(numImDesde.toString());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.nimpuhasta"));
        cell = row.createCell((short)6);
        StringBuffer numImHasta = new StringBuffer(listadoResBean.getTerritorio());
        if(StringUtils.isNotEmpty(listadoResBean.getAgnoImpugnacionHasta())){
        	if(StringUtils.isNotEmpty(listadoResBean.getTerritorio())){
        		numImHasta.append("/");
        	}
        	numImHasta.append(listadoResBean.getAgnoImpugnacionHasta());
        	if(StringUtils.isNotEmpty(listadoResBean.getNumImpugnacionHasta())){
        		numImHasta.append("/").append(listadoResBean.getNumImpugnacionHasta());
        	}
        }
        cell.setCellValue(numImHasta.toString());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        //fila 10

        cell = row.getCell((short)8);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fimpugdesde"));
        cell = row.createCell((short)11); 
        if(StringUtils.isNotEmpty(listadoResBean.getFechaEntradaDesde())){
        	cell.setCellValue(listadoResBean.getFechaEntradaDesde());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        cell = row.getCell((short)12);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fimpughasta"));
        cell = row.createCell((short)13); 
        if(StringUtils.isNotEmpty(listadoResBean.getFechaEntradaHasta())){
        	cell.setCellValue(listadoResBean.getFechaEntradaHasta());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
      //fila 11
        row = sheet.getRow((short)13); 
        cell = row.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.listados.numLaudoDesde"));
        cell = row.createCell((short)2); 
        StringBuffer numLauDesde = new StringBuffer(listadoResBean.getTerritorio());
        if(StringUtils.isNotEmpty(listadoResBean.getAgnoLaudoDesde())){
        	if(StringUtils.isNotEmpty(listadoResBean.getTerritorio())){
        		numLauDesde.append("/");
        	}
        	numLauDesde.append(listadoResBean.getAgnoLaudoDesde());
        	if(StringUtils.isNotEmpty(listadoResBean.getNumLaudoDesde())){
        		numLauDesde.append("/").append(listadoResBean.getNumLaudoDesde());
        	}
        }
        cell.setCellValue(numLauDesde.toString());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.listados.numLaudoHasta"));
        cell = row.createCell((short)6); 
        StringBuffer numLauHasta = new StringBuffer(listadoResBean.getTerritorio());
        if(StringUtils.isNotEmpty(listadoResBean.getAgnoLaudoHasta())){
        	if(StringUtils.isNotEmpty(listadoResBean.getTerritorio())){
        		numLauHasta.append("/");
        	}
        	numLauHasta.append(listadoResBean.getAgnoLaudoHasta());
        	if(StringUtils.isNotEmpty(listadoResBean.getNumLaudoHasta())){
        		numLauHasta.append("/").append(listadoResBean.getNumLaudoHasta());
        	}
        }
        cell.setCellValue(numLauHasta.toString());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
      //fila 12
        cell = row.getCell((short)8);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.flaudodesde"));
        cell = row.createCell((short)11); 
        if(StringUtils.isNotEmpty(listadoResBean.getFechaLaudoDesde())){
        	cell.setCellValue(listadoResBean.getFechaLaudoDesde());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        cell = row.getCell((short)12);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.flaudohasta"));
        cell = row.createCell((short)13); 
        if(StringUtils.isNotEmpty(listadoResBean.getFechaLaudoHasta())){
        	cell.setCellValue(listadoResBean.getFechaLaudoHasta());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        int j=-4;
        String dniArb = "";
        String territ = "";
        String dniCurr = "";
        String territCurr = "";
        int serie = 0;
        for(int i=0;i<listaImpugnaciones.size();i++){
        	W83bListImpugnacionesBean beanCurrent = (W83bListImpugnacionesBean)listaImpugnaciones.get(i);
        	dniCurr = beanCurrent.getDniArbitro();
        	territCurr = beanCurrent.getTerritorio();
        	
        	if(!dniCurr.equals(dniArb)||!territCurr.equals(territ)){
        		j=j+6;
        		serie = 0;
        		row = sheet.createRow((short)W83bClsConstantes.DIECISEIS+j);
	        		            
	            cell = row.createCell((short)0);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+j,Short.parseShort("0"),W83bClsConstantes.DIECISEIS+j,Short.parseShort("1")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.listados.arbitroSimple"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)1);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)2);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.territorio"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)3);
	            if(StringUtils.isNotEmpty(beanCurrent.getDescTerritorio())){
	            	cell.setCellValue(beanCurrent.getDescTerritorio());
	            }

	            
	            cell = row.createCell((short)4);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.dni"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)5);
	            if(StringUtils.isNotEmpty(beanCurrent.getDniArbitro())){
	            	cell.setCellValue(beanCurrent.getDniArbitro());
	            }
	            
	            cell = row.createCell((short)6);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+j,Short.parseShort("6"),W83bClsConstantes.DIECISEIS+j,Short.parseShort("9")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.nombreApellidos"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)7);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)8);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)9);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            
	            cell = row.createCell((short)10);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+j,Short.parseShort("10"),W83bClsConstantes.DIECISEIS+j,Short.parseShort("13")));//NOPMD
	            if(StringUtils.isNotEmpty(beanCurrent.getNombreArbitro())){
	            	cell.setCellValue(beanCurrent.getNombreArbitro());
	            }
	            cell = row.createCell((short)11);
	            cell = row.createCell((short)12);
	            cell = row.createCell((short)13);
	            if(beanCurrent.getNombreArbitro()!=null){
			        if(60<(beanCurrent.getNombreArbitro()).length()){
			        	row.setHeightInPoints((short)(16*((beanCurrent.getNombreArbitro()).length()/60)+1));
			        }
	        	}
	            
	            
	        	row = sheet.createRow((short)W83bClsConstantes.DIECIOCHO+j);
	            cell = row.createCell((short)0);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("0"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("1")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.nImpugnacionCorto"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)1);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)2);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nPreaviso"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)3);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nActa"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)4);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("4"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("7")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.razonSocial"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)5);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)6);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)7);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)8);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fImpugnacionCorto"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)9);
	            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+j,Short.parseShort("9"),W83bClsConstantes.DIECIOCHO+j,Short.parseShort("10")));//NOPMD
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fEnvioArbitro"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            cell = row.createCell((short)10);
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)11);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.num_laudo"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)12);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.rdolaudo"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)13);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.fech_laudo"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
	            
	            cell = row.createCell((short)14);
	            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fDesestimiento"));
	            cell.setCellStyle(estiloCabeceraTabla(excel));
        	}else{
        		j=j+1;
            	serie++;
        	}
        	    	
        	// Creacin de la fila 1
        	row = sheet.createRow((short)W83bClsConstantes.DIEZYNUEVE+j);
        	cell = row.createCell((short)0);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+j,Short.parseShort("0"),W83bClsConstantes.DIEZYNUEVE+j,Short.parseShort("1")));//NOPMD
        	cell.setCellValue(beanCurrent.getTerritorio()+"/"+beanCurrent.getAgnoImpugnacion()+"/"+W83bUtilidadesComunes.rellenarCeros(beanCurrent.getNumImpugnacion()));
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	cell = row.createCell((short)1);
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	// Creacin de la fila 2
        	cell = row.createCell((short)2);
        	StringBuffer numD = new StringBuffer();//NOPMD
        	if ("2".equals(beanCurrent.getOrderby())){
        		numD = new StringBuffer(beanCurrent.getTerritorio());//NOPMD
        		if(StringUtils.isNotEmpty(beanCurrent.getAgnoActa())){
            		numD.append("/").append(beanCurrent.getAgnoActa());
                	if(StringUtils.isNotEmpty(beanCurrent.getNumActa())){
                		numD.append("/").append(W83bUtilidadesComunes.rellenarCeros(beanCurrent.getNumActa()));
                	}
                }else{
                	numD = new StringBuffer();//NOPMD
                }
        	}
        	cell.setCellValue(numD.toString());
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	
        	// Creacin de la fila 3
        	cell = row.createCell((short)3);
        	StringBuffer numH = new StringBuffer();//NOPMD
        	if ("1".equals(beanCurrent.getOrderby())){
        		numH = new StringBuffer(beanCurrent.getTerritorio());//NOPMD
        		if(StringUtils.isNotEmpty(beanCurrent.getAgnoActa())){
            		numH.append("/").append(beanCurrent.getAgnoActa());
                	if(StringUtils.isNotEmpty(beanCurrent.getNumActa())){
                		numH.append("/").append(W83bUtilidadesComunes.rellenarCeros(beanCurrent.getNumActa()));
                	}
                }else{
                	numH = new StringBuffer();//NOPMD
                }
        	}
        	
        	cell.setCellValue(numH.toString());
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	// Creacin de la fila 4
        	cell = row.createCell((short)4);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+j,Short.parseShort("4"),W83bClsConstantes.DIEZYNUEVE+j,Short.parseShort("7")));//NOPMD
        	if(StringUtils.isNotEmpty(beanCurrent.getRazonSocial())){
        		cell.setCellValue(beanCurrent.getRazonSocial().toUpperCase());
        	}
        	cell.setCellStyle(estiloFila(serie,excel));
        	cell = row.createCell((short)5);
        	cell.setCellStyle(estiloFila(serie,excel));
        	cell = row.createCell((short)6);
        	cell.setCellStyle(estiloFila(serie,excel));
        	cell = row.createCell((short)7);
        	cell.setCellStyle(estiloFila(serie,excel));
        	
        	// Creacin de la fila 5
        	cell = row.createCell((short)8);
        	if(StringUtils.isNotEmpty(beanCurrent.getFechaImpugnacion())){
        		String fechaImpug= beanCurrent.getFechaImpugnacion();
        		cell.setCellValue(fechaImpug);
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));

        	// Creacin de la fila 6
        	cell = row.createCell((short)9);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+j,Short.parseShort("9"),W83bClsConstantes.DIEZYNUEVE+j,Short.parseShort("10")));//NOPMD
        	//la fecha la recibo como tipo char (fecha(yyyy-MM-dd) + hora) asi que lo formateo a mi gusto
        	if(StringUtils.isNotEmpty(beanCurrent.getFechaEnvArbi())){
        		cell.setCellValue(beanCurrent.getFechaEnvArbi());
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	cell = row.createCell((short)10);
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	// Creacin de la fila 10
        	cell = row.createCell((short)11);
        	StringBuffer numL = new StringBuffer(beanCurrent.getTerritorio());//NOPMD
        	if(StringUtils.isNotEmpty(beanCurrent.getAgnoLaudo())){
        		numL.append("/").append(beanCurrent.getAgnoLaudo());
            	if(StringUtils.isNotEmpty(beanCurrent.getNumLaudo())){
            		numL.append("/").append(W83bUtilidadesComunes.rellenarCeros(beanCurrent.getNumLaudo()));
            	}
            }else{
            	numL = new StringBuffer();//NOPMD
            }
	    	cell.setCellValue(numL.toString());
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	// Creacin de la fila 11
        	cell = row.createCell((short)12);
        	if(W83bClsConstantes.CONSTANTE_CASTELLANO.equalsIgnoreCase(idioma)){
        		cell.setCellValue(beanCurrent.getDescResulLaudo().toString());
        	}else if(W83bClsConstantes.CONSTANTE_EUSKARA.equalsIgnoreCase(idioma)){
        		cell.setCellValue(beanCurrent.getDescEusResulLaudo().toString());
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	
        	// Creacin de la fila 12
        	cell = row.createCell((short)13);
        	if(StringUtils.isNotEmpty(beanCurrent.getFechaLaudo())){
        		String fechaLaudo= beanCurrent.getFechaLaudo();
        		cell.setCellValue(fechaLaudo);
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	// Creacin de la fila 13
        	cell = row.createCell((short)14);
        	if(StringUtils.isNotEmpty(beanCurrent.getFechaDeses())){
        		cell.setCellValue(beanCurrent.getFechaDeses());
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(serie,excel));
        	
        	if(beanCurrent.getRazonSocial()!=null){
		        if(65<(beanCurrent.getRazonSocial()).length()){
		        	row.setHeightInPoints((short)(20*((beanCurrent.getRazonSocial()).length()/65)+1));
		        }
        	}
        	if(!dniCurr.equals(dniArb)||!territCurr.equals(territ)){
        		dniArb = dniCurr;
        		territ = territCurr;
        	}

        }
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoImpugnacionesResueltas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
		
		return null;
	}
	
	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	
	/**
	 * Estilo cabecera tabla.
	 *
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloCabeceraTabla (W83bUtilidadesExcel excel){
		return excel.styleTextoCabeceraTabla;//NOPMD
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
